var FD;
(function (FD) {
	var TreeMapNode = (function () {
		function TreeMapNode(data) {
			this.children = [];
			this.frame = new FD.TreeMapNodeFrame(this);
			this.data = data;
			this.parent = null;
			this.color = this.hslToRgb(
				this.getRandomArbitrary(0, 1),
				this.getRandomArbitrary(0.07, 0.35),
				this.getRandomArbitrary(0.7, 0.95)
			);
		}

		TreeMapNode.prototype.hasChildren = function() {
			return this.children.length > 0;
		};
	
		TreeMapNode.prototype.isLeaf = function() {
			return false;
		};
	
		TreeMapNode.prototype.isNode = function() {
			return true;
		};

		TreeMapNode.prototype.addNode = function(node) {
			this.children.push(node);
			node.parent = this;

			return node;
		};

		TreeMapNode.prototype.getFrame = function() {
			return this.frame;
		};

		TreeMapNode.prototype.getWeight = function() {
			var weight = 0;

			for(var child in this.children) {
				weight += this.children[child].getWeight();
			}

			return weight;
		};

		TreeMapNode.prototype.sort = function() {
			this.children.sort(function(a, b) {
				return b.getWeight() - a.getWeight();
			});
			this.children.map(function(node) { node.sort(); });
		};

		TreeMapNode.prototype.hslToRgb = function(h, s, l){
			var r, g, b;

			if(s === 0) {
				r = g = b = l; // achromatic
			}
			else {
				var hue2rgb = function hue2rgb(p, q, t) {
					if(t < 0) t += 1;
					if(t > 1) t -= 1;
					if(t < 1/6) return p + (q - p) * 6 * t;
					if(t < 1/2) return q;
					if(t < 2/3) return p + (q - p) * (2/3 - t) * 6;
					return p;
				};

				var q = l < 0.5 ? l * (1 + s) : l + s - l * s;
				var p = 2 * l - q;
				r = hue2rgb(p, q, h + 1/3);
				g = hue2rgb(p, q, h);
				b = hue2rgb(p, q, h - 1/3);
			}

			//return [Math.round(r * 255), Math.round(g * 255), Math.round(b * 255)];
			return '#' + Math.round(r * 255).toString(16) + '' + Math.round(g * 255).toString(16) + '' + Math.round(b * 255).toString(16);
		};

		TreeMapNode.prototype.getRandomArbitrary = function(min, max) {
			return Math.random() * (max - min) + min;
		};
		
		return TreeMapNode;
	})();
	FD.TreeMapNode = TreeMapNode;
})(FD || (FD = {}));
