var __extends = this.__extends || function (d, b) {
	for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	function __() { this.constructor = d; }
	__.prototype = b.prototype;
	d.prototype = new __();
};
/// <reference path="ConeTreeVisualisation.ts" />
/// <reference path="ConeTreeNode.ts" />
/// <reference path="../resources/three.d.ts" />
/// <reference path="../debugPrinter.ts" />
/// <reference path="../FDEventHandler.ts" />
/// <reference path="../FDHelpers.ts" />
var FD;
(function (FD) {
	var TreeMapEventHandler = (function (_super) {
		__extends(TreeMapEventHandler, _super);
		function TreeMapEventHandler(debug, fluidDiagrams) {
			_super.call(this, debug, fluidDiagrams);
			this.filter = {
				status: false,
				x: 0,
				y: 0,
				dx: 0,
				dy: 0
			};
		}

		TreeMapEventHandler.prototype.onMouseClick = function (e, element) {
			var vis = this.fluidDiagrams.getVisualisation();
			var filter = { data: 'Pressestelle, Amtsblatt und Öffentlichkeitsarbeit' };
			var node = vis.find(filter);

			if(!this.filter.status) {
				this.filter.status = true;
				this.filter.x = node.frame.x;
				this.filter.y = node.frame.y;
				this.filter.dx = node.frame.dx;
				this.filter.dy = node.frame.dy;

				new TWEEN.Tween({
					x: node.frame.x,
					y: node.frame.y,
					dx: node.frame.dx,
					dy: node.frame.dy
				}).to({
					x: 0,
					y: 0,
					dx: vis.width,
					dy: vis.height
				}, 1000).onUpdate( function () {
					vis.deleteScene();
					vis.show(filter, this.x, this.y, this.dx, this.dy);
				}).start();
			}
			else {
				this.filter.status = false;

				new TWEEN.Tween({
					x: 0,
					y: 0,
					dx: vis.width,
					dy: vis.height
				}).to({
					x: this.filter.x,
					y: this.filter.y,
					dx: this.filter.dx,
					dy: this.filter.dy
				}, 1000).onUpdate( function () {
					vis.deleteScene();
					vis.show(filter, this.x, this.y, this.dx, this.dy);
				}).onComplete(function() {
					vis.deleteScene();
					vis.show();
				}).start();
			}
		};

		TreeMapEventHandler.prototype.onMouseMove = function (e) {};
		TreeMapEventHandler.prototype.onMouseUp = function (e) {};
		TreeMapEventHandler.prototype.onMouseDown = function (e) {};

		return TreeMapEventHandler;
	})(FD.FDEventHandler);
	FD.TreeMapEventHandler = TreeMapEventHandler;
})(FD || (FD = {}));
