/*
 * Created by Diab, Dokter, Hatbauer, Rocnik
 *
 * ivis Group 1 - Summer Term 2013
 *
**/

/// <reference path="../FDNode.ts" />
/// <reference path="ScatterPlotNode.ts" />
module FD {
    export class Scattiner {
        public dataSetName: string;
        public entries: { [nodeId: string]: ScatterPlotNode; } = {};

        private xScale: number;
        private yScale: number;

        constructor(name: string) {
            this.dataSetName = name;
        }

        public addEntrie(nodeId: string, scatterPlotNode: ScatterPlotNode) {
            this.entries[nodeId] = scatterPlotNode;
        }

        public setXScale(scale: number) {
            this.xScale = scale;
        }

        public setYScale(scale: number) {
            this.yScale = scale;
        }

        public autoScale(xAxisMax: number, yAxisMax: number) {
            var xMax = 0;
            var yMax = 0;

            for (var i in this.entries) {
                var xValue = this.entries[i].getX();
                var yValue = this.entries[i].getY();

                if (xValue > xMax)
                    xMax = xValue;

                if (yValue > yMax)
                    yMax = yValue;
            }

            this.xScale = xAxisMax / xMax;
            this.yScale = yAxisMax / yMax;
        }

        public getElementById(nodeId: string): ScatterPlotNode {
            return this.entries[nodeId];
        }

    }
}