/*
* Created by Diab, Dokter, Hatbauer, Rocnik
*
* ivis Group 1 - Summer Term 2013
*
**/
/// <reference path="../FDNode.ts" />
/// <reference path="ScatterPlotNode.ts" />
var FD;
(function (FD) {
    var Scattiner = (function () {
        function Scattiner(name) {
            this.entries = {};
            this.dataSetName = name;
        }
        Scattiner.prototype.addEntrie = function (nodeId, scatterPlotNode) {
            this.entries[nodeId] = scatterPlotNode;
        };

        Scattiner.prototype.setXScale = function (scale) {
            this.xScale = scale;
        };

        Scattiner.prototype.setYScale = function (scale) {
            this.yScale = scale;
        };

        Scattiner.prototype.autoScale = function (xAxisMax, yAxisMax) {
            var xMax = 0;
            var yMax = 0;

            for (var i in this.entries) {
                var xValue = this.entries[i].getX();
                var yValue = this.entries[i].getY();

                if (xValue > xMax)
                    xMax = xValue;

                if (yValue > yMax)
                    yMax = yValue;
            }

            this.xScale = xAxisMax / xMax;
            this.yScale = yAxisMax / yMax;
        };

        Scattiner.prototype.getElementById = function (nodeId) {
            return this.entries[nodeId];
        };
        return Scattiner;
    })();
    FD.Scattiner = Scattiner;
})(FD || (FD = {}));
