/// <reference path="ScatterPlotVisualisation.ts" />
/// <reference path="../FDEventHandler.ts" />
/// <reference path="../resources/three.d.ts" />
/// <reference path="../debugPrinter.ts" />
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
/*
* Created by Diab, Dokter, Hatbauer, Rocnik
*
* ivis Group 1 - Summer Term 2013
*
**/
var FD;
(function (FD) {
    var ScatterPlotEventHandler = (function (_super) {
        __extends(ScatterPlotEventHandler, _super);
        /**
        * Creates a ScatterPlotVisualisationEventHandler object
        *
        * @constructor
        * @param debug: switch debug mode on/off
        * @param fluidDiagram: FluidDiagrams object to connect to the
        *                      scatter plot visualisation
        */
        function ScatterPlotEventHandler(debug, fluidDiagram) {
            _super.call(this, debug, fluidDiagram);
            this.visualisation = (this.fluidDiagrams.getVisualisation());
        }
        /**
        * Register a html UI element
        *
        * @function registerInfoWindow
        * @param container: UI element
        */
        ScatterPlotEventHandler.prototype.registerInfoWindow = function (containerName) {
            this.infoWindow = (containerName);
        };

        /**
        * Perform action after a click event
        * Searches for the clicked node and prints
        * the retrieved data to the infoWindow
        *
        * @function onMouseClick
        * @param e: event info
        * @param element: clicked element
        */
        ScatterPlotEventHandler.prototype.onMouseClick = function (e, element) {
            if (element != undefined) {
                if (element instanceof THREE.Mesh) {
                    element = element;

                    var cNames = this.visualisation.nodes[0].getData();
                    var j = 0;
                    var colNames = [];
                    for (var c in cNames)
                        colNames[j++] = c;

                    for (var node in this.fluidDiagrams.rootNodes) {
                        var currentNode = this.fluidDiagrams.rootNodes[node];
                        if (currentNode.getUniqueId() == element.name.substr(5)) {
                            this.initInfoWindow(currentNode);

                            FD.debugPrinter.print("------------------------------------", this.debug);
                            FD.debugPrinter.print("nodeName: " + element.name.substr(5), this.debug);
                            var data = currentNode.getData();
                            var val = 0;
                            j = 0;
                            for (var d in data) {
                                var colName = colNames[j++];
                                val = parseFloat(data[d]);
                                FD.debugPrinter.print(colName + ": " + val, this.debug);
                            }
                        }
                    }
                }
            }
        };

        /**
        * Record mouse position on move
        *
        * @function onMouseMove
        * @param e: event info
        */
        ScatterPlotEventHandler.prototype.onMouseMove = function (e) {
            if (this.mouseDown == true && this.selectedMesh != null) {
                var x = e.clientX - this.mouseDownPosition.x;
                var y = e.clientY - this.mouseDownPosition.y;
                this.mouseDownPosition.x = e.clientX;
                this.mouseDownPosition.y = e.clientY;
            }
        };

        /**
        * Respond to user input on the data/icon/color/size
        * selection and invoke the updating of the plot
        *
        * @function onUserSelection
        */
        ScatterPlotEventHandler.prototype.onUserSelection = function () {
            FD.debugPrinter.print("User Selection!", this.debug);
            for (var node in this.fluidDiagrams.rootNodes) {
                var n = this.fluidDiagrams.rootNodes[node];

                //   debugPrinter.print("nodeName: " + n.getUniqueId(),this.debug);
                var geom = n.getAllGeometry();
                n.getNodeSceneGraph().remove(geom[0]);
                geom.splice(0, 1);
            }
            this.visualisation.update();
        };

        /**
        * Initialises the infoWindow where the data
        * of a clicked node will be displayed
        *
        * @function initWindow
        * @param clickedElem: the clicked element of which
        *                     the data is to be displayed
        */
        ScatterPlotEventHandler.prototype.initInfoWindow = function (clickedElem) {
            var container = document.getElementById(this.infoWindow);
            if (container)
                container.innerHTML = null;
            var table = document.createElement("table");
            var tr = document.createElement("tr");
            var td1 = document.createElement("td");
            var td2 = document.createElement("td");
            var nodeName = document.createElement("nodeName");
            var element = document.createElement("element");
            element.textContent = "element name";
            nodeName.textContent = clickedElem.getUniqueId();
            td1.appendChild(element);
            td2.appendChild(nodeName);
            tr.appendChild(td1);
            tr.appendChild(td2);
            table.appendChild(tr);

            var cNames = this.visualisation.nodes[0].getData();
            var j = 0;
            var colNames = [];
            for (var c in cNames)
                colNames[j++] = c;

            var data = clickedElem.getData();
            var i = 0;

            for (var d in data) {
                var tr = document.createElement("tr");
                var td1 = document.createElement("td");
                var td2 = document.createElement("td");

                var label = document.createElement("label");
                label.textContent = colNames[i++];
                td1.appendChild(label);

                var value = document.createElement("value");
                value.textContent = parseFloat(data[d]);
                td2.appendChild(value);

                tr.appendChild(td1);
                tr.appendChild(td2);
                table.appendChild(tr);
            }
            container.appendChild(table);
        };

        /**
        * Update scenegraph for animation
        * effects etc (not used)
        *
        * @function update
        */
        ScatterPlotEventHandler.prototype.update = function () {
            //animation update here
        };
        return ScatterPlotEventHandler;
    })(FD.FDEventHandler);
    FD.ScatterPlotEventHandler = ScatterPlotEventHandler;
})(FD || (FD = {}));
