var FD;
(function (FD) {
    var PolarAreaWedge = (function () {
        function PolarAreaWedge(name) {
            this.cName = name;
            this.sections = [];
            this.maxValue = 0;
            this.position = 0;
        }

        PolarAreaWedge.prototype.addSection = function (year, value) {
            this.sections[this.sections.length] = { year: year, value: value };
            this.sections.sort(function(a, b) {
                return a.value - b.value;
            });
        };

        PolarAreaWedge.prototype.setMaxValue = function(maxValue) {
            this.maxValue = maxValue;
        };

        PolarAreaWedge.prototype.setPosition = function(position) {
            this.position = position;
        };

        PolarAreaWedge.prototype.normalizeAndOrderSections = function() {
            var sections = [];
            var from = 0;

            for(var s in this.sections) {
                var section = this.sections[s];
                var normalizedValue = ((1 / this.maxValue) * section.value);

                sections.push({
                    year: section.year,
                    from: from,
                    to: normalizedValue
                });

                from = normalizedValue;
            }

            return sections;
        };
        
        return PolarAreaWedge;
    })();
    FD.PolarAreaWedge = PolarAreaWedge;
})(FD || (FD = {}));
