var __extends = this.__extends || function (d, b) {
	for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
	function __() { this.constructor = d; }
	__.prototype = b.prototype;
	d.prototype = new __();
};

var FD;
(function (FD) {
	var PolarAreaVisualisation = (function (_super) {
		__extends(PolarAreaVisualisation, _super);
		function PolarAreaVisualisation(debug, fluidDiagram) {
			_super.call(this, debug, fluidDiagram);
			this.wedges = [];
			this.maxValue = Number.MIN_VALUE;
		}
		
		PolarAreaVisualisation.prototype.visualise = function () {
			this.backgroundColor = 0xffffff;

			for(var i = 0; i < this.nodes[0].children.length; i++) {
				var newWedge = new FD.PolarAreaWedge(this.nodes[0].children[i].name);
				newWedge.setPosition(i);

				for(var j = 0; j < this.nodes[0].children[i].children.length; j++) {
					newWedge.addSection(this.nodes[0].children[i].children[j].year, this.nodes[0].children[i].children[j].value);

					if(this.nodes[0].children[i].children[j].value > this.maxValue) {
						this.maxValue = this.nodes[0].children[i].children[j].value;
					}
				}

				this.wedges.push(newWedge);
			}

			for (var wedge in this.wedges) {
				this.wedges[wedge].setMaxValue(this.maxValue);
			}

			this.x1 = 30;
			this.x2 = this.width - 30;
			this.y1 = 30;
			this.y2 = this.height - 30;

			this.center = {
				x: ((this.x2 - this.x1) / 2) + this.x1,
				y: ((this.y2 - this.y1) / 2) + this.y1
			};
			this.angle = Math.PI * 2 / this.nodes[0].children.length;

			if(this.width > this.height) {
				this.maxRadius = (this.height - 60) / 2;
			}
			else {
				this.maxRadius = (this.width - 60) / 2;
			}
			
			/*console.log("bounds: " + this.x1 + "/" + this.y1 + " --- " + this.x2 + "/" + this.y2);
			console.log("center: " + this.center.x + "/" + this.center.y);
			console.log("angle:  " + this.angle);
			console.log("radius: " + this.maxRadius);*/

			/*for (var n in this.nodes) {
				var linegeom = new THREE.Geometry();
				linegeom.dynamic = true;
                linegeom.verticesNeedUpdate = true;

				linegeom.vertices.push(new THREE.Vector3(0, 0, 0));
				linegeom.vertices.push(new THREE.Vector3(40, 90, 0));
				linegeom.vertices.push(new THREE.Vector3(90, 120, 0));

				var line = new THREE.Line(linegeom, new THREE.LineBasicMaterial({ color: 0x000000 }));
				this.fluidDiagrams.addSceneObject(line);
			}*/

			this.drawGrid();
			this.drawWedges();
		};

		PolarAreaVisualisation.prototype.drawGrid = function () {
			for(var wedge in this.wedges) {
				var linegeom = new THREE.Geometry();

				var x1 = this.center.x;
				var y1 = this.center.y;
				var z1 = 0;
				linegeom.vertices.push(new THREE.Vector3(x1, y1, z1));

				var axisPoint = this.getAxisPoint(this.angle * this.wedges[wedge].position, this.maxRadius);
				var x2 = axisPoint.x; //this.center.x + Math.cos(this.angle * this.wedges[wedge].position) * this.maxRadius;
				var y2 = axisPoint.y; //this.center.y + Math.sin(this.angle * this.wedges[wedge].position) * this.maxRadius;
				var z2 = 0;
				linegeom.vertices.push(new THREE.Vector3(x2, y2, z2));

				var line = new THREE.Line(linegeom, new THREE.LineBasicMaterial({ color: 0x000000 }));
				this.fluidDiagrams.addSceneObject(line);

				this.addLabel(x2, y2, this.wedges[wedge].cName, this.angle * this.wedges[wedge].position);
			}
		};

		PolarAreaVisualisation.prototype.addLabel = function(xOff, yOFF, name, angle) {
			var fontSize = 11;
			var height = 14;
		    var size = 128;

		    var canvas1 = document.createElement('canvas');
		    canvas1.height = height;
		    canvas1.width = size;
		    var context1 = canvas1.getContext('2d');

		    context1.font = fontSize + "px Arial";
		    context1.textAlign = 'left';
		    context1.fillStyle = "rgba(0,0,0,1)";
		    context1.fillText(name, 0, fontSize);

		    var metrics = context1.measureText(name);

		    var canvas2 = document.createElement('canvas');
		    canvas2.height = height * 2;
		    canvas2.width = metrics.width * 2;
		    var context2 = canvas2.getContext('2d');
		    //context2.fillStyle = "rgba(0,255,0,.5)";
		    //context2.fillRect(0, 0, metrics.width, height * 2);

		    context2.font = fontSize + "px Arial";
		    context2.textAlign = 'left';
		    context2.fillStyle = "rgba(0,0,0,1)";
		    context2.fillText(name, 0, fontSize);

		    var texture1 = new THREE.Texture(canvas2);
		    texture1.needsUpdate = true;
		    var textMat = new THREE.MeshBasicMaterial({ map: texture1 });
		    textMat.transparent = true;
		    textMat.side = THREE.DoubleSide;

		    var textPlane = new THREE.PlaneGeometry(metrics.width * 2, height * 2);
		    var textMesh = new THREE.Mesh(textPlane, textMat);
		    textMesh.position = new THREE.Vector3(xOff, yOFF, 0);

		    textMesh.rotation.z = angle;

		    this.fluidDiagrams.addSceneObject(textMesh);
		};

		PolarAreaVisualisation.prototype.getAxisPoint = function(angle, radius) {
			return {
				x: this.center.x + Math.cos(angle) * radius,
				y: this.center.y + Math.sin(angle) * radius
			};
		};

		PolarAreaVisualisation.prototype.drawWedges = function () {
			for(var w in this.wedges) {
				var wedge = this.wedges[w];

				var sections = wedge.normalizeAndOrderSections();

				for(var s in sections) {
					var section = sections[s];

					var angleFrom = wedge.position * this.angle;
					var angleTo = (wedge.position + 1) * this.angle;

					this.drawWedge(angleFrom, angleTo, section.to * this.maxRadius, this.getColorForYear(section.year));
				}
			}

		};

		PolarAreaVisualisation.prototype.getColorForYear = function(year) {
			switch(+year) {
				case 1987:
					return 0xd84c35;
				case 1988:
					return 0xe48831;
				case 1989:
					return 0xe8b830;
				default:
					return 0x000000;
			}
		};

		PolarAreaVisualisation.prototype.drawWedge = function(angleFrom, angleTo, radiusTop, color) {
			var axisPoint;
			var shape = new THREE.Shape();
			
			shape.absarc(this.center.x, this.center.y, radiusTop, angleFrom, angleTo);
			shape.lineTo(this.center.x, this.center.y);

			axisPoint = this.getAxisPoint(angleTo, radiusTop);
			shape.lineTo(axisPoint.x, axisPoint.y);

			var geometry = new THREE.ShapeGeometry(shape);
			var material = new THREE.MeshBasicMaterial({ color: color });

			var obj = new THREE.Mesh(geometry, material);
			this.fluidDiagrams.addSceneObject(obj);

			edges = new THREE.EdgesHelper(obj, 0x000000);
			this.fluidDiagrams.addSceneObject(edges);
		};

		return PolarAreaVisualisation;
	})(FD.FDVisualisation);
	FD.PolarAreaVisualisation = PolarAreaVisualisation;
})(FD || (FD = {}));
