/// <reference path="../FDNode.ts" />

module FD {
    export class ParallelCoordinatesColumn {
        public cName: string;
        public entries: { [nodeId: string]: number; } = {};
        public vertices: THREE.Vector3[];
        public lowHandle: THREE.Mesh;
        public highHandle: THREE.Mesh;
        public sortHandle: THREE.Mesh;
        private guideLine: THREE.Line;
        public label: THREE.Mesh;
        private maxY: number;
        private minY: number;
        private filterTop: number;
        private filterBottom: number;
        private topLable: THREE.Mesh;
        private bottomLable: THREE.Mesh;
        private columnSceneGraph: THREE.Object3D



        constructor(name: string) {
            this.cName = name;
            this.columnSceneGraph = new THREE.Object3D();
            this.vertices = [];
        }

        public addEntrie(nodeId: string, value: number) {

            if (isNaN(value))
                value = 0;
            this.entries[nodeId] = value;
        }

        public normalizeTo(normVal: number) {
            var min = this.getMin();
            var max = this.getMax();
            for (var i in this.entries) {
                var val = this.entries[i];
                this.entries[i] = (val - min) / (max - min) * normVal;
            }

        }



        public getMin(): number {
            var min = Number.MAX_VALUE;
            for (var i in this.entries) {
                if (this.entries[i] < min) {
                    min = this.entries[i];
                }
            }
            return min;
        }

        public getMax(): number {
            var max = 0;
            for (var i in this.entries) {
                if (this.entries[i] > max) {
                    max = this.entries[i];
                }
            }
            return max;
        }
        
        public setLine(l: THREE.Line){
            this.guideLine = l;
            this.columnSceneGraph.add(l);
        }

        public setLowHandle(h: THREE.Mesh) {
            this.lowHandle = h;
            this.columnSceneGraph.add(h);
        }
        public setHighHandle(h: THREE.Mesh) {
            this.highHandle = h;
            this.columnSceneGraph.add(h);
        }
        public getLowHandle(): THREE.Mesh {
            return this.lowHandle;
        }
        public getHighHandle(): THREE.Mesh {
            return this.highHandle;
        }
        
        public setLabel(l:THREE.Mesh){
            this.label = l;   
            this.columnSceneGraph.add(l);     
        }
        public getLabel():THREE.Mesh{
            return this.label;
        }

        public setMaxY(max: number) {
            this.maxY = max;
            this.filterTop = max;
        }

        public setMinY(min: number) {
            this.minY = min;
            this.filterBottom = min;
        }

        public getMaxY() {
            return this.maxY;
        }

        public getMinY() {
            return this.minY;
        }


        public getFilterBottom() {
            
            return this.filterBottom - Math.abs(this.minY);
            //return this.filterBottom;
        }
        public getFilterTop() {
            return this.filterTop - Math.abs(this.minY);
        }
        public setFilterTop(top: number) {
            this.filterTop = top;
        }
        public setFilterBottom(bottom: number) {
            this.filterBottom = bottom;
        }


        public setSortHandle(h: THREE.Mesh) {
            this.sortHandle = h;
            this.columnSceneGraph.add(h);
        }
        public getSortHandle(): THREE.Mesh {
            return this.sortHandle;
        }
        public reverseElements() {
            
            var max = this.getMax();
            var min = this.getMin();
            for (var e in this.entries) {
                var d = max - this.entries[e] + min;
                //debugPrinter.print("max: "+max+" min: "+min+ " val: "+this.entries[e]+ " newVal: "+d, true);
                this.entries[e] = d;
            }

        }

        public setTopLable(lable: THREE.Mesh) {
            this.topLable = lable;
            this.columnSceneGraph.add(lable);
        }
        public setBottomLable(lable: THREE.Mesh) {
            this.bottomLable = lable;
            this.columnSceneGraph.add(lable);
        }
        public getTopLable(): THREE.Mesh {
            return this.topLable;
        }
        public getBottomLable(): THREE.Mesh {
            return this.bottomLable;
        }

        public getColumnSceneGraph(){
            return this.columnSceneGraph;
        }

    }
}
