/// <reference path="../FDNode.ts" />
var FD;
(function (FD) {
    var ParallelCoordinatesColumn = (function () {
        function ParallelCoordinatesColumn(name) {
            this.entries = {};
            this.cName = name;
            this.columnSceneGraph = new THREE.Object3D();
            this.vertices = [];
        }
        ParallelCoordinatesColumn.prototype.addEntrie = function (nodeId, value) {
            if (isNaN(value))
                value = 0;
            this.entries[nodeId] = value;
        };

        ParallelCoordinatesColumn.prototype.normalizeTo = function (normVal) {
            var min = this.getMin();
            var max = this.getMax();
            for (var i in this.entries) {
                var val = this.entries[i];
                this.entries[i] = (val - min) / (max - min) * normVal;
            }
        };

        ParallelCoordinatesColumn.prototype.getMin = function () {
            var min = Number.MAX_VALUE;
            for (var i in this.entries) {
                if (this.entries[i] < min) {
                    min = this.entries[i];
                }
            }
            return min;
        };

        ParallelCoordinatesColumn.prototype.getMax = function () {
            var max = 0;
            for (var i in this.entries) {
                if (this.entries[i] > max) {
                    max = this.entries[i];
                }
            }
            return max;
        };

        ParallelCoordinatesColumn.prototype.setLine = function (l) {
            this.guideLine = l;
            this.columnSceneGraph.add(l);
        };

        ParallelCoordinatesColumn.prototype.setLowHandle = function (h) {
            this.lowHandle = h;
            this.columnSceneGraph.add(h);
        };
        ParallelCoordinatesColumn.prototype.setHighHandle = function (h) {
            this.highHandle = h;
            this.columnSceneGraph.add(h);
        };
        ParallelCoordinatesColumn.prototype.getLowHandle = function () {
            return this.lowHandle;
        };
        ParallelCoordinatesColumn.prototype.getHighHandle = function () {
            return this.highHandle;
        };

        ParallelCoordinatesColumn.prototype.setLabel = function (l) {
            this.label = l;
            this.columnSceneGraph.add(l);
        };
        ParallelCoordinatesColumn.prototype.getLabel = function () {
            return this.label;
        };

        ParallelCoordinatesColumn.prototype.setMaxY = function (max) {
            this.maxY = max;
            this.filterTop = max;
        };

        ParallelCoordinatesColumn.prototype.setMinY = function (min) {
            this.minY = min;
            this.filterBottom = min;
        };

        ParallelCoordinatesColumn.prototype.getMaxY = function () {
            return this.maxY;
        };

        ParallelCoordinatesColumn.prototype.getMinY = function () {
            return this.minY;
        };

        ParallelCoordinatesColumn.prototype.getFilterBottom = function () {
            return this.filterBottom - Math.abs(this.minY);
            //return this.filterBottom;
        };
        ParallelCoordinatesColumn.prototype.getFilterTop = function () {
            return this.filterTop - Math.abs(this.minY);
        };
        ParallelCoordinatesColumn.prototype.setFilterTop = function (top) {
            this.filterTop = top;
        };
        ParallelCoordinatesColumn.prototype.setFilterBottom = function (bottom) {
            this.filterBottom = bottom;
        };

        ParallelCoordinatesColumn.prototype.setSortHandle = function (h) {
            this.sortHandle = h;
            this.columnSceneGraph.add(h);
        };
        ParallelCoordinatesColumn.prototype.getSortHandle = function () {
            return this.sortHandle;
        };
        ParallelCoordinatesColumn.prototype.reverseElements = function () {
            var max = this.getMax();
            var min = this.getMin();
            for (var e in this.entries) {
                var d = max - this.entries[e] + min;

                //debugPrinter.print("max: "+max+" min: "+min+ " val: "+this.entries[e]+ " newVal: "+d, true);
                this.entries[e] = d;
            }
        };

        ParallelCoordinatesColumn.prototype.setTopLable = function (lable) {
            this.topLable = lable;
            this.columnSceneGraph.add(lable);
        };
        ParallelCoordinatesColumn.prototype.setBottomLable = function (lable) {
            this.bottomLable = lable;
            this.columnSceneGraph.add(lable);
        };
        ParallelCoordinatesColumn.prototype.getTopLable = function () {
            return this.topLable;
        };
        ParallelCoordinatesColumn.prototype.getBottomLable = function () {
            return this.bottomLable;
        };

        ParallelCoordinatesColumn.prototype.getColumnSceneGraph = function () {
            return this.columnSceneGraph;
        };
        return ParallelCoordinatesColumn;
    })();
    FD.ParallelCoordinatesColumn = ParallelCoordinatesColumn;
})(FD || (FD = {}));
