var TickScale = (function () {
    function TickScale() {
    }
    /*
    constructor(min: number, max: number, ticks: number) {
    this.minPoint = min;
    this.maxPoint = max;
    this.maxTicks = ticks;
    this.calculate();
    }
    */
    TickScale.prototype.getTickSpacing = function () {
        return this.tickSpacing;
    };

    TickScale.prototype.getRoundedMin = function () {
        return this.tickMin;
    };

    TickScale.prototype.getRoundedMax = function () {
        return this.tickMax;
    };

    TickScale.prototype.calculate = function () {
        this.range = this.niceNum(this.maxPoint - this.minPoint, false);
        this.tickSpacing = this.niceNum(this.range / (this.maxTicks - 1), true);
        this.tickMin = Math.floor(this.minPoint / this.tickSpacing) * this.tickSpacing;
        this.tickMax = Math.ceil(this.maxPoint / this.tickSpacing) * this.tickSpacing;
    };

    TickScale.prototype.niceNum = function (range, round) {
        var exponent;
        var fraction;
        var niceFraction;

        exponent = Math.floor(this.log10(range));
        fraction = range / Math.pow(10, exponent);

        if (round) {
            if (fraction < 1.5)
                niceFraction = 1;
else if (fraction < 3)
                niceFraction = 2;
else if (fraction < 7)
                niceFraction = 5;
else
                niceFraction = 10;
        } else {
            if (fraction <= 1)
                niceFraction = 1;
else if (fraction <= 2)
                niceFraction = 2;
else if (fraction <= 5)
                niceFraction = 5;
else
                niceFraction = 10;
        }
        return niceFraction * Math.pow(10, exponent);
    };

    TickScale.prototype.log10 = function (val) {
        return Math.log(val) / Math.LN10;
    };

    TickScale.prototype.setMinMaxPoints = function (minPoint, maxPoint) {
        this.minPoint = minPoint;
        this.maxPoint = maxPoint;
        this.calculate();
    };

    TickScale.prototype.setMaxTicks = function (maxTicks) {
        this.maxTicks = maxTicks;
        this.calculate();
    };
    return TickScale;
})();
