/*
 * Created by Ari Rauhala, Christine Pichler
 */


/// <reference path="../FDNode.ts" />
/// <reference path="../debugPrinter.ts" />

module FD {
    export class LineChartLine {

        public nodes: { [key: string]: number; } = {};
        private color: number;
        private maximum: number;
        private minimum: number;
        private lineName: string;

        constructor(id: string) {

            this.color = 0x000000; //default color is black
            this.maximum = -Number.MAX_VALUE;
            this.minimum = Number.MAX_VALUE;
            this.lineName = id;
        }

        public getMax() {
            return this.maximum;
        }

        public getMin() {
            return this.minimum;
        }

        public changeLineColor(insertColor: number) {
            this.color = insertColor;
        }

        public addEntries(keys: string[], values: number[]) {
            for (var i = 0; i < keys.length; i++) {
                this.addEntrie(keys[i], values[i]);
            }

        }

        public addEntrie(key: string, value: number) {
            if (isNaN(value)) {
                value = 0;
            }
            this.nodes[key] = value;
            // check whether the new value is a new maximum or new minimum
            this.maximum = Math.max(this.maximum, value);
            this.minimum = Math.min(this.minimum, value);
        }


        public setColor(color: number) {
            this.color = color;
        }

        public getColor() {
            return this.color;
        }

        public getLineName() {
            return this.lineName;
        }
    }
}