/*
* Created by Ari Rauhala, Christine Pichler
*/
/// <reference path="../FDNode.ts" />
/// <reference path="../debugPrinter.ts" />
var FD;
(function (FD) {
    var LineChartLine = (function () {
        function LineChartLine(id) {
            this.nodes = {};
            this.color = 0x000000; //default color is black
            this.maximum = -Number.MAX_VALUE;
            this.minimum = Number.MAX_VALUE;
            this.lineName = id;
        }
        LineChartLine.prototype.getMax = function () {
            return this.maximum;
        };

        LineChartLine.prototype.getMin = function () {
            return this.minimum;
        };

        LineChartLine.prototype.changeLineColor = function (insertColor) {
            this.color = insertColor;
        };

        LineChartLine.prototype.addEntries = function (keys, values) {
            for (var i = 0; i < keys.length; i++) {
                this.addEntrie(keys[i], values[i]);
            }
        };

        LineChartLine.prototype.addEntrie = function (key, value) {
            if (isNaN(value)) {
                value = 0;
            }
            this.nodes[key] = value;

            // check whether the new value is a new maximum or new minimum
            this.maximum = Math.max(this.maximum, value);
            this.minimum = Math.min(this.minimum, value);
        };

        LineChartLine.prototype.setColor = function (color) {
            this.color = color;
        };

        LineChartLine.prototype.getColor = function () {
            return this.color;
        };

        LineChartLine.prototype.getLineName = function () {
            return this.lineName;
        };
        return LineChartLine;
    })();
    FD.LineChartLine = LineChartLine;
})(FD || (FD = {}));
