/*
 * Created by Ari Rauhala, Christine Pichler
 */


/// <reference path="LineChartVisualisation.ts" />
/// <reference path="../FDEventHandler.ts" />
/// <reference path="../resources/three.d.ts" />

module FD {
    export class LineChartEventHandler extends FDEventHandler {

        private selectedMesh: THREE.Mesh;
        private mouseDownPosition: THREE.Vector2;
        private visualisation: LineChartVisualisation;
        private activeMat;
        private inactiveMat;
        private action;
        private selectedColor;
        private texture1;
        private context1;
        private canvas1;
        private hoveredElem;
        private spriteMat;
        private sprite1;
        private fontSize: number;
        private textCreated: boolean;

        constructor(debug: boolean, fluidDiagrams: FluidDiagrams) {
            super(debug, fluidDiagrams);
            this.mouseDown = false;
            this.mouseDownPosition = new THREE.Vector2();
            this.visualisation = <LineChartVisualisation>this.fluidDiagrams.getVisualisation();
            this.textCreated = false;
            this.fontSize = 13;
        }

        public onMouseDown(e: Event) {

            var clickedElem = this.fluidDiagrams.objectFromMouse((<any>e).clientX, (<any>e).clientY);
            if (!clickedElem) {
                this.visualisation.setLineIsSelected(false);
                this.visualisation.updateGui();
                return;
            }
            var isLabel = this.isNameALabel(clickedElem.name);

            if (clickedElem.name == this.visualisation.axisYTitle) {
                var tmp = prompt("Give me a new Name", clickedElem.name)
            if (tmp)
                    this.visualisation.axisYTitle = tmp;
            }
            else if (clickedElem.name == this.visualisation.axisXTitle) {
                var tmp = prompt("Give me a new Name", clickedElem.name)
            if (tmp)
                    this.visualisation.axisXTitle = tmp;
            }
            else if (clickedElem.name == this.visualisation.title) {
                var tmp = prompt("Give me a new Name", clickedElem.name)
            if (tmp)
                    this.visualisation.title = tmp;
            }
            else if (isLabel != "" && (<any>e).clientX < this.visualisation.diagramLeftPadding)
                return;
            //line selection
            else if (clickedElem instanceof THREE.Mesh || clickedElem instanceof THREE.MeshBasicMaterial) {
                if (!clickedElem || clickedElem.name == "Legend")
                    return;

                var name = clickedElem.name;

                debugPrinter.print("clikedElem name: " + clickedElem.name, this.debug);
                var lineName: string;
                lineName = clickedElem.name;
                var splitLineName = lineName.split("\n");
                lineName = splitLineName[0];
                debugPrinter.print("lineName: " + lineName, this.debug);

                this.visualisation.setSelectedLineIDString(lineName);
                this.visualisation.setLineIsSelected(true);
                this.visualisation.updateGui();
            }

            if (tmp) {
                this.visualisation.updateGui();
            }


            this.mouseDown = true;
        }

        public onMouseUp(e: Event) {

            this.mouseDown = false;
            this.selectedMesh = null;
        }

        public onMouseMove(e: Event) {
            if (!this.textCreated)
                this.createText();

            this.context1.clearRect(0, 0, 300, 300);

            this.hoveredElem = this.fluidDiagrams.objectFromMouse((<any>e).clientX, (<any>e).clientY);

            var height = this.fontSize;
            if (this.hoveredElem instanceof THREE.Mesh && this.hoveredElem.name != "background") {

                if (!this.hoveredElem || this.hoveredElem.name == "Legend" || this.hoveredElem.name == "")
                    return;

                var text: string = "";
                var name: string = this.hoveredElem.name;
                var textSplited: string[];
                var lineName = this.hoveredElem.name;

                var isLabel = this.isNameALabel(name);
                if (name == this.visualisation.axisYTitle || name == this.visualisation.axisXTitle || name == this.visualisation.title) {
                    text = "Click to change :)";
                }

                else if (isLabel != "") {
                    text = isLabel;
                }
                else {
                    text = name;
                }

                var width: number = 0;
                textSplited = text.split("\n");
                height = textSplited.length * this.fontSize;

                for (var i = 0; i < textSplited.length; i++) {
                    var widthTmp: number = this.context1.measureText(textSplited[i]).width;
                    if (widthTmp > width) {
                        width = widthTmp;
                    }
                }

                this.context1.fillStyle = "rgba(0,0,0,0.95)"; // black border
                this.context1.fillRect(0, 0, width + 8, height + 8);
                this.context1.fillStyle = "rgba(255,255,255,1)"; // white filler
                this.context1.fillRect(2, 2, width + 4, height + 4);
                this.context1.fillStyle = "rgba(0,0,0,1)"; // text color
                var x: number = 0;
                var y: number = 0;

                if (width + (<any>e).clientX < this.visualisation.diagramWidth)
                    x = (<any>e).clientX;
                else
                    x = (<any>e).clientX - width - 40;

                if ((height + (<any>e).clientY) < this.visualisation.diagramHeight)
                    y = (<any>e).clientY - 90;
                else
                    y = (<any>e).clientY - 100 - height;

                this.sprite1.position.set(x, y, 0);
                width = 0;
                for (var i = 0; i < textSplited.length; i++) {
                    this.context1.fillText(textSplited[i], 4, (this.fontSize * (i + 1) + 2));
                }
            }

            this.texture1.needsUpdate = true;

            if (e.type == "mouseout") {
                this.context1.clearRect(0, 0, 300, 300);
                debugPrinter.print("event: " + e.type, this.debug);
            }
            if (this.hoveredElem != null && this.hoveredElem.name == "") {
                this.context1.clearRect(0, 0, 300, 300);
                this.texture1.needsUpdate = true;
            }
        }



        private createText() {
            // create a canvas element
            this.canvas1 = document.createElement('canvas');
            this.context1 = this.canvas1.getContext('2d');
            this.context1.font = "Bold " + (this.fontSize + 2) + "px Arial";
            this.context1.fillStyle = "rgba(0,0,0,0.95)";

            // canvas contents will be used for a texture
            this.texture1 = new THREE.Texture(this.canvas1)
        this.texture1.needsUpdate = true;
            var spriteMaterial = new THREE.SpriteMaterial({ map: this.texture1, useScreenCoordinates: true, alignment: THREE.SpriteAlignment.topLeft });
            this.sprite1 = new THREE.Sprite(spriteMaterial);
            this.sprite1.scale.set(300, 150, 1.0);
            this.fluidDiagrams.scene.add(this.sprite1);
            this.textCreated = true;
        }

        public toggleColor(color: number) {
            this.visualisation.newNodeColor = color;
            this.visualisation.setLineColor(this.visualisation.getSelectedLineIDString(), color);
            this.visualisation.newColorSelected = true;
            document.body.style.cursor = 'default'
        this.visualisation.updateGui();
        }



        public toggleNodeRepres(rep: number) {
            //debugPrinter.print("node " + rep, this.debug);
            switch (rep) {
                case 0:
                    this.visualisation.nodeRep = this.visualisation.createSquare();
                    break;
                case 1:
                    this.visualisation.nodeRep = this.visualisation.createTriangle();
                    break;
                case 2:
                    this.visualisation.nodeRep = this.visualisation.createCircle();
                    break;
                case 3:
                    this.visualisation.nodeRep = this.visualisation.createDiamond();
                    break;
                case 4:
                    this.visualisation.nodeRep = this.visualisation.createStar();
                    break;
            }
            this.visualisation.updateGui();
        }

        public toggleLegend() {
            if (!this.visualisation.legendVisible) {
                this.visualisation.legendVisible = true;
                this.visualisation.createLegend();
            }
            else {
                this.visualisation.legendVisible = false;
                this.visualisation.updateGui();
            }
        }

        public toggleNodeSize(size: number) {
            debugPrinter.print("nodesize " + size, this.debug);
            this.visualisation.nodeSize = size;
            this.visualisation.updateGui();
        }

        public toggleLineWidth(size: number) {
            debugPrinter.print("lineWidth " + size, this.debug);
            this.visualisation.lineSize = size;
            this.visualisation.updateGui();
        }

        public toggleXGridsBetween(grids: number) {
            debugPrinter.print("xgrids " + grids, this.debug);
            this.visualisation.xGridsBetweenValues = grids;
            this.visualisation.updateGui();
        }

        public toggleYGridsBetween(grids: number) {
            debugPrinter.print("ygrids " + grids, this.debug);
            this.visualisation.yGridsBetweenValues = grids;
            this.visualisation.updateGui();
        }

        public toggleXGrid(check: boolean) {
            if (check)
                this.visualisation.isXGridDrawn = true;
            else
                this.visualisation.isXGridDrawn = false;
            this.visualisation.updateGui();
        }

        public toggleYGrid(check: boolean) {
            if (check)
                this.visualisation.isYGridDrawn = true;
            else
                this.visualisation.isYGridDrawn = false;
            this.visualisation.updateGui();
        }

        public toggleXDate(check: boolean) {
            check ? this.visualisation.xValueIsYear = true : this.visualisation.xValueIsYear = false;
            this.visualisation.updateGui();
        }

        private isNameALabel(name: string) {
            var lines = this.visualisation.getLines();
            for (var l in lines) {
                if (name == l || (name == l.substr(0, 9) + "..."))
                    return l;
            }
            return "";
        }

        public changeDecimalPoint(mark) {
            this.visualisation.floatSeperationMark = mark;
            this.visualisation.updateGui();
        }

        public changeSeparationmark(mark) {
            this.visualisation.separationMark = mark;
            this.visualisation.updateGui();
        }

        public toggleTickAmount(val) {
            this.visualisation.yTickAmount = val;
            this.visualisation.calculateTicks();
            this.visualisation.updateGui();
        }
    }
}
