/*
 * Created by Ari Rauhala, Christine Pichler
 */


/// <reference path="../FDNode.ts" />



interface Point {
    x: number;
    y: number;
}

class FDLine {

    private startPoint: Point;
    private endPoint: Point;
    private width: number;


    constructor(start: Point, end: Point, width: number) {
        this.startPoint = start;
        this.endPoint = end;
        this.width = width;
    }

    drawLine() {
        var lineGeom = new THREE.Geometry();
        lineGeom.vertices.push(new THREE.Vector3(this.startPoint.x, this.startPoint.y + (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.startPoint.x, this.startPoint.y - (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.endPoint.x, this.endPoint.y - (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.endPoint.x, this.endPoint.y + (this.width / 2), 0));
        lineGeom.faces.push(new THREE.Face4(0, 1, 2, 3));
        lineGeom.computeBoundingBox();
        lineGeom.computeFaceNormals();
        return lineGeom;
    }
}




