/*
* Created by Ari Rauhala, Christine Pichler
*/
/// <reference path="../FDNode.ts" />

var FDLine = (function () {
    function FDLine(start, end, width) {
        this.startPoint = start;
        this.endPoint = end;
        this.width = width;
    }
    FDLine.prototype.drawLine = function () {
        var lineGeom = new THREE.Geometry();
        lineGeom.vertices.push(new THREE.Vector3(this.startPoint.x, this.startPoint.y + (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.startPoint.x, this.startPoint.y - (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.endPoint.x, this.endPoint.y - (this.width / 2), 0));
        lineGeom.vertices.push(new THREE.Vector3(this.endPoint.x, this.endPoint.y + (this.width / 2), 0));
        lineGeom.faces.push(new THREE.Face4(0, 1, 2, 3));
        lineGeom.computeBoundingBox();
        lineGeom.computeFaceNormals();
        return lineGeom;
    };
    return FDLine;
})();
