/*
Created by Benedict Wright
*/
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
/// <reference path="FDParser.ts" />
/// <reference path="resources/jquery.d.ts" />
var FD;
(function (FD) {
    var JSONParser = (function (_super) {
        __extends(JSONParser, _super);
        function JSONParser(debug) {
            _super.call(this, debug);
            this.alreadyParsed = [];
        }
        //@params
        //json: json encoded Data
        // expected Format: Array of root elements (even if only 1 root)
        JSONParser.prototype.parse = function () {
            for (var elem in this.rawData) {
                this.parseElement(this.rawData[elem], "", null);
            }
        };

        //creates a new Node or returns an existing one with given unique identifier
        JSONParser.prototype.createNode = function (identifier) {
            for (var node in this.allNodes) {
                if (this.allNodes[node].uniqueId == identifier) {
                    return this.allNodes[node];
                }
            }
            var newNode = new FD.FDNode();
            newNode.setUniqueId(identifier);
            this.addNode(newNode);
            return newNode;
        };

        JSONParser.prototype.notYetParsed = function (identifier) {
            for (var s in this.alreadyParsed) {
                if (this.alreadyParsed[s] == identifier) {
                    return false;
                }
            }
            return true;
        };

        JSONParser.prototype.parseElement = function (root, depth, parent) {
            var current = this.createNode(root[this.uId]);

            if (this.notYetParsed(current.getUniqueId())) {
                //debugPrinter.print(depth + root[this.uId], this.debug);
                if (parent == null) {
                    this.addRootNode(current);
                } else {
                    //set childs parent
                    parent.addChild(current);

                    current.setParent(parent);
                }
            }
            this.alreadyParsed.push(current.getUniqueId());

            for (var key in root) {
                if (key != this.uId && key != this.childrenId && key != this.siblingId) {
                    current[key] = root[key];
                }
            }

            for (var elem in root[this.childrenId]) {
                this.parseElement(root[this.childrenId][elem], depth + "    ", current);
            }

            for (var elem in root[this.siblingId]) {
                //CAUTION do not parse same node multiple times (endles loop!!)
                var siblingNode = this.createNode(root[this.siblingId][elem][this.uId]);

                current.addSibling(siblingNode);

                if (this.notYetParsed(siblingNode.getUniqueId())) {
                    this.parseElement(root[this.siblingId][elem], depth, parent);
                }
            }
        };
        return JSONParser;
    })(FD.FDParser);
    FD.JSONParser = JSONParser;
})(FD || (FD = {}));
