/// <reference path="HBWedge.ts" />
/// <reference path="HBPoint.ts" />
/// <reference path="../FDHelpers.ts" />
/// <reference path="../FDNode.ts" />
/// <reference path="../resources/three.d.ts" />
module FD {
    export class TreeNode {
        public childrenweights : number;
        public weight : number;

        public z : HBPoint;
        public oldz : HBPoint;
        public origz : HBPoint;
        public wedge_ : HBWedge;

        public ppcirclelayout_:PolarPoint2D;
        public renderpos_: THREE.Vector3;
        public linepos_:THREE.Vector3;

        public fdNode_:FDNode;

        public icon_:THREE.Mesh;
        public line_:THREE.Geometry;
        public name_:string;
        public label :THREE.Sprite;
    
        private parent_:TreeNode;
        private children_:TreeNode[];

        constructor(fdNode:FDNode, makeLabel:boolean) {
            this.renderpos_ = new THREE.Vector3();
            this.linepos_ = new THREE.Vector3();
            this.ppcirclelayout_ = new PolarPoint2D();

            this.fdNode_=fdNode;
            this.name_=this.fdNode_.getUniqueId();
            this.children_ = [];

            this.parent_=null;
            this.z = new HBPoint();
            this.oldz = new HBPoint();
            this.origz = new HBPoint();
            this.childrenweights=0;
            this.weight=1;

            var mat = new THREE.MeshBasicMaterial({ color: 0x000000 });
            mat.side = THREE.DoubleSide;
            var circle = new THREE.CircleGeometry(3.5, 10, 0, Math.PI * 2);
            this.icon_ = new THREE.Mesh(circle, mat);
            this.icon_.position=this.renderpos_;
			if(makeLabel==true){
				this.label = makeSprite(this.name_, 18);
				this.icon_.add(this.label)
				this.label.position = this.renderpos_;
			}
        }

        public getIcon(){
            return this.icon_;
        }

        public getParentNode(){
            return this.parent_;
        }

        public getChildNode(index:number){
            if(index<0||index>=this.children_.length)
                return null;
            return this.children_[index];
        }
        public addChild(child:TreeNode){
            this.children_.push(child)
        }
        public setParent(parent:TreeNode){
            this.parent_=parent;
        }

        public getChildCount(){
            return this.children_.length;
        }

    }
}
