/// <reference path="HBWedge.ts" />
/// <reference path="HBPoint.ts" />
/// <reference path="../FDHelpers.ts" />
/// <reference path="../FDNode.ts" />
/// <reference path="../resources/three.d.ts" />
var FD;
(function (FD) {
    var TreeNode = (function () {
        function TreeNode(fdNode, makeLabel) {
            this.renderpos_ = new THREE.Vector3();
            this.linepos_ = new THREE.Vector3();
            this.ppcirclelayout_ = new FD.PolarPoint2D();

            this.fdNode_ = fdNode;
            this.name_ = this.fdNode_.getUniqueId();
            this.children_ = [];

            this.parent_ = null;
            this.z = new FD.HBPoint();
            this.oldz = new FD.HBPoint();
            this.origz = new FD.HBPoint();
            this.childrenweights = 0;
            this.weight = 1;

            var mat = new THREE.MeshBasicMaterial({ color: 0x000000 });
            mat.side = THREE.DoubleSide;
            var circle = new THREE.CircleGeometry(3.5, 10, 0, Math.PI * 2);
            this.icon_ = new THREE.Mesh(circle, mat);
            this.icon_.position = this.renderpos_;
            if (makeLabel == true) {
                this.label = FD.makeSprite(this.name_, 18);
                this.icon_.add(this.label);
                this.label.position = this.renderpos_;
            }
        }
        TreeNode.prototype.getIcon = function () {
            return this.icon_;
        };

        TreeNode.prototype.getParentNode = function () {
            return this.parent_;
        };

        TreeNode.prototype.getChildNode = function (index) {
            if (index < 0 || index >= this.children_.length)
                return null;
            return this.children_[index];
        };
        TreeNode.prototype.addChild = function (child) {
            this.children_.push(child);
        };
        TreeNode.prototype.setParent = function (parent) {
            this.parent_ = parent;
        };

        TreeNode.prototype.getChildCount = function () {
            return this.children_.length;
        };
        return TreeNode;
    })();
    FD.TreeNode = TreeNode;
})(FD || (FD = {}));
