/// <reference path="HBWedge.ts" />
/// <reference path="HBPoint.ts" />
/// <reference path="TreeNode.ts" />
module FD {
    export class TreeGraph {

        public DEFAULTTREESIZE = 1024;
        public rootnode_:TreeNode;
        public focusnode_:TreeNode;
        public allnodes_:TreeNode[];

        constructor(root:TreeNode) {
           this.rootnode_=root;
           this.allnodes_=[];
           this.collectAllNodes(this.rootnode_)
        }

        public getRootNode(){
            return this.rootnode_;
        }        

        public getTreeNodeCount (){
            return this.allnodes_.length;
        }


        public getTreeNode (index:number){
            if (index < 0 || index >= this.allnodes_.length)
                return null;

            return this.allnodes_[index];
        }

        private collectAllNodes (treenode:TreeNode){
            if (treenode == null)
              return;

            // add selected nodes
            this.allnodes_.push (treenode);

            // process children
            var childcount = treenode.getChildCount ();
            for (var i = 0; i < childcount; i++){
              this.collectAllNodes(treenode.getChildNode(i));
            }
        }

        public setFocusNode(focus:TreeNode){
            this.focusnode_=focus;
        }
        public getFocusNode(){
            return this.focusnode_;
        }


    }
}
