/// <reference path="HBWedge.ts" />
/// <reference path="HBPoint.ts" />
/// <reference path="TreeNode.ts" />
var FD;
(function (FD) {
    var TreeGraph = (function () {
        function TreeGraph(root) {
            this.DEFAULTTREESIZE = 1024;
            this.rootnode_ = root;
            this.allnodes_ = [];
            this.collectAllNodes(this.rootnode_);
        }
        TreeGraph.prototype.getRootNode = function () {
            return this.rootnode_;
        };

        TreeGraph.prototype.getTreeNodeCount = function () {
            return this.allnodes_.length;
        };

        TreeGraph.prototype.getTreeNode = function (index) {
            if (index < 0 || index >= this.allnodes_.length)
                return null;

            return this.allnodes_[index];
        };

        TreeGraph.prototype.collectAllNodes = function (treenode) {
            if (treenode == null)
                return;

            // add selected nodes
            this.allnodes_.push(treenode);

            // process children
            var childcount = treenode.getChildCount();
            for (var i = 0; i < childcount; i++) {
                this.collectAllNodes(treenode.getChildNode(i));
            }
        };

        TreeGraph.prototype.setFocusNode = function (focus) {
            this.focusnode_ = focus;
        };
        TreeGraph.prototype.getFocusNode = function () {
            return this.focusnode_;
        };
        return TreeGraph;
    })();
    FD.TreeGraph = TreeGraph;
})(FD || (FD = {}));
