var FD;
(function (FD) {
    var PolarPoint2D = (function () {
        function PolarPoint2D(length, angle) {
            if (typeof length === "undefined") { length = 0; }
            if (typeof angle === "undefined") { angle = 0; }
            this.PI = Math.PI;
            this.PI_05 = Math.PI * 0.5;
            this.PI_075 = Math.PI * 0.75;
            this.PI_10 = Math.PI;
            this.PI_15 = Math.PI * 1.5;
            this.PI_20 = Math.PI * 2.0;
            this.PI_25 = Math.PI * 2.5;
            this.length_ = length;
            this.angle_ = angle;
        }
        PolarPoint2D.prototype.clear = function () {
            this.angle_ = 0;
            this.length_ = 0;
        };

        PolarPoint2D.prototype.set = function (length, angle) {
            this.length_ = length;
            this.angle_ = this.normalizeAngle(angle);
        };

        PolarPoint2D.prototype.setCartesian = function (posx, posy) {
            this.angle_ = this.getPolarAngle(posx, posy);
            this.length_ = this.getPolarLength(posx, posy);
        };

        PolarPoint2D.prototype.getLength = function () {
            return this.length_;
        };

        PolarPoint2D.prototype.getAngle = function () {
            return this.angle_;
        };

        PolarPoint2D.prototype.getPosX = function () {
            return this.length_ * Math.cos(this.angle_);
        };

        PolarPoint2D.prototype.getPosY = function () {
            return this.length_ * Math.sin(this.angle_);
        };

        PolarPoint2D.prototype.addAngle = function (angle) {
            this.angle_ = this.normalizeAngle(this.angle_ + angle);
        };

        PolarPoint2D.prototype.distanceAngle = function (angle2) {
            return this.polarDistanceAngle(this.angle_, angle2);
        };

        PolarPoint2D.prototype.copy = function (sourcepoint) {
            this.length_ = sourcepoint.getLength();
            this.angle_ = sourcepoint.getAngle();
        };

        PolarPoint2D.prototype.normalizeAngle = function (angle) {
            // fist check (needs no calculation time)
            if (angle < this.PI_20 && angle >= 0)
                return angle;

            // second check (needs less calculation time)
            if (angle < 0 && angle >= this.PI_20 * -1)
                return angle + this.PI_20;

            // full calculation for all cases
            angle = angle % this.PI_20;
            if (angle < 0)
                angle += this.PI_20;

            return angle;
        };

        PolarPoint2D.prototype.polarDistanceAngle = function (angle1, angle2) {
            // normalize angles
            angle1 = this.normalizeAngle(angle1);
            angle2 = this.normalizeAngle(angle2);

            // calculate distance
            var distance = angle2 - angle1;

            // find the smaller one
            if (distance > this.PI)
                distance -= this.PI_20;
            else if (distance < -this.PI)
                distance += this.PI_20;

            return distance;
        };

        PolarPoint2D.prototype.getPolarAngle = function (posx, posy) {
            // return zero, if y =0 and x equal or greater 0
            // the tan2 returns
            if (posy == 0 && posx >= 0)
                return 0;

            var tanangle = Math.atan2(posx, posy);

            //System.err.println ("\ntanangle: " + tanangle + " / " + round2 (toDegrees (tanangle)));
            var angle;

            // calculate real angle in circle from atan2-value
            if (tanangle < 0) {
                // the left hemisphere
                angle = -tanangle + this.PI_05;
            } else {
                // the right hemisphere
                if (tanangle < this.PI_05) {
                    // the top right quarter
                    angle = this.PI_05 - tanangle;
                } else {
                    // the bottom right quarter
                    angle = this.PI_25 - tanangle;
                }
            }

            return angle;
        };

        PolarPoint2D.prototype.getPolarLength = function (posx, posy) {
            return Math.sqrt(posx * posx + posy * posy);
        };
        return PolarPoint2D;
    })();
    FD.PolarPoint2D = PolarPoint2D;
})(FD || (FD = {}));
