/// <reference path="HBPoint.ts" />
/// <reference path="PolarPoint2D.ts" />
var FD;
(function (FD) {
    var HBWedge = (function () {
        function HBWedge() {
        }
        HBWedge.prototype.getAngleWidth = function () {
            var angle = this.omega_ - this.alpha_;
            if (angle < 0)
                angle += 2 * Math.PI;

            return angle;
        };

        HBWedge.prototype.getBisectionAngle = function () {
            var angle = this.alpha_ + (this.getAngleWidth() / 2.0);

            return angle;
        };

        HBWedge.prototype.translate = function (transx, transy, trans) {
            var point = new FD.HBPoint();
            var PP2D = new FD.PolarPoint2D();
            if (trans) {
                // translate the first angle / point
                point.x = Math.cos(this.alpha_);
                point.y = Math.sin(this.alpha_);
                point.translate(0, 0, trans);
                this.alpha_ = PP2D.getPolarAngle(point.x, point.y);

                // translage the second angle / point
                point.x = Math.cos(this.omega_);
                point.y = Math.sin(this.omega_);
                point.translate(0, 0, trans);
                this.omega_ = PP2D.getPolarAngle(point.x, point.y);
            } else {
                // translate the first angle / point
                point.x = Math.cos(this.alpha_);
                point.y = Math.sin(this.alpha_);
                point.translate(transx, transy);
                this.alpha_ = PP2D.getPolarAngle(point.x, point.y);

                // translage the second angle / point
                point.x = Math.cos(this.omega_);
                point.y = Math.sin(this.omega_);
                point.translate(transx, transy);
                this.omega_ = PP2D.getPolarAngle(point.x, point.y);
            }
        };

        HBWedge.prototype.specialTrans = function (alpha, beta) {
            var point = new FD.HBPoint();
            var PP2D = new FD.PolarPoint2D();

            // translate the first angle / point
            point.x = Math.cos(this.alpha_);
            point.y = Math.sin(this.alpha_);
            point.specialTrans(alpha, beta);
            this.alpha_ = PP2D.getPolarAngle(point.x, point.y);

            // translage the second angle / point
            point.x = Math.cos(this.omega_);
            point.y = Math.sin(this.omega_);
            point.specialTrans(alpha, beta);
            this.omega_ = PP2D.getPolarAngle(point.x, point.y);
        };

        // --- debug ---
        HBWedge.prototype.toString = function () {
            var ret = "alpha / omega: " + Math.round(this.alpha_) + " / " + Math.round(this.omega_);
            ret += ", anglewidth: " + Math.round(this.getAngleWidth());
            ret += ", bisectionangle: " + Math.round(this.getBisectionAngle()) + "\n";

            return ret;
        };
        return HBWedge;
    })();
    FD.HBWedge = HBWedge;
})(FD || (FD = {}));
