/// <reference path="HBWedge.ts" />
/// <reference path="../FDNode.ts" />
/// <reference path="../resources/three.d.ts" />
var FD;
(function (FD) {
    var HBPoint = (function () {
        function HBPoint(x, y) {
            if (typeof x === "undefined") { x = 0; }
            if (typeof y === "undefined") { y = 0; }
            this.x = x;
            this.y = y;
        }
        HBPoint.prototype.isValid = function () {
            return (this.d2() < 1.0);
        };

        HBPoint.prototype.conjugate = function () {
            this.y = this.y * -1;
        };

        HBPoint.prototype.multiply = function (z) {
            var tx = this.x;
            var ty = this.y;
            this.x = (tx * z.x) - (ty * z.y);
            this.y = (tx * z.y) + (ty * z.x);
        };

        HBPoint.prototype.divide = function (z) {
            var d = z.d2();
            var tx = this.x;
            var ty = this.y;
            this.x = ((tx * z.x) + (ty * z.y)) / d;
            this.y = ((ty * z.x) - (tx * z.y)) / d;
        };

        //Hack for THREE used to be sub
        HBPoint.prototype.subHB = function (a, b) {
            this.x = a.x - b.x;
            this.y = a.y - b.y;
        };

        HBPoint.prototype.arg = function () {
            var a = Math.atan(this.y / this.x);

            if (this.x < 0) {
                a += Math.PI;
            } else if (this.y < 0) {
                a += 2 * Math.PI;
            }
            return a;
        };

        HBPoint.prototype.d2 = function () {
            return (this.x * this.x) + (this.y * this.y);
        };

        HBPoint.prototype.d = function (p) {
            if (p) {
                return Math.sqrt((p.x - this.x) * (p.x - this.x) + (p.y - this.y) * (p.y - this.y));
            } else {
                return Math.sqrt(this.d2());
            }
        };

        //combined two functions to one. If t required set tx and ty to 0 in function call
        HBPoint.prototype.translate = function (tx, ty, t) {
            if (t) {
                var numx = this.x + t.x;
                var numy = this.y + t.y;

                // denominator
                var denx = (this.x * t.x) + (this.y * t.y) + 1.0;
                var deny = (this.y * t.x) - (this.x * t.y);

                // division
                var dd = (denx * denx) + (deny * deny);
                this.x = ((numx * denx) + (numy * deny)) / dd;
                this.y = ((numy * denx) - (numx * deny)) / dd;
            } else {
                // numerator
                var numx = this.x + tx;
                var numy = this.y + ty;

                // denominator
                var denx = (this.x * tx) + (this.y * ty) + 1.0;
                var deny = (this.y * tx) - (this.x * ty);

                // division
                var dd = (denx * denx) + (deny * deny);
                this.x = ((numx * denx) + (numy * deny)) / dd;
                this.y = ((numy * denx) - (numx * deny)) / dd;
            }
        };

        HBPoint.prototype.specialTrans = function (alpha, beta) {
            // z = (alpha * z + beta) / (conj(alpha) + conj(beta)*z)
            var dx = (this.x * beta.x) + (this.y * beta.y) + alpha.x;
            var dy = (this.y * beta.x) - (this.x * beta.y) - alpha.y;
            var d = (dx * dx) + (dy * dy);

            var tx = (this.x * alpha.x) - (this.y * alpha.y) + beta.x;
            var ty = (this.x * alpha.y) + (this.y * alpha.x) + beta.y;

            this.x = ((tx * dx) + (ty * dy)) / d;
            this.y = ((ty * dx) - (tx * dy)) / d;
        };

        HBPoint.prototype.rotate = function (theta) {
            var px = (this.x * theta.x) + (this.y * theta.y);
            var py = (this.y * theta.x) - (this.x * theta.y);

            this.x = px;
            this.y = py;
        };

        HBPoint.prototype.toString = function () {
            return "(" + this.x + " : " + this.y + ")E";
        };
        return HBPoint;
    })();
    FD.HBPoint = HBPoint;
})(FD || (FD = {}));
