/// <reference path="Scatterplot/ScatterPlotVisualisation.ts" />
/// <reference path="BarChart/BarChartVisualisation.ts" />
/// <reference path="FDVisualisation.ts" />
/// <reference path="ConeTree\ConeTreeVisualisation.ts" />

/// <reference path="ParallelCoordinates\ParallelCoordinatesVisualisation.ts" />

/// <reference path="LineChart\LineChartVisualisation.ts" />
/// <reference path="Hyperbolic\HypB.ts" />



module FD {
    export class FDVisualisationFactory {
        debug: Boolean = true;
        private fd: FluidDiagrams;


        /**
         * Factory to create predefined visualisations
         * @class FDVisualisationFactory
         * @classdesc Factory to create predefined visualisations
         * @param {bool} debug  
         * @param {FluidDiagrams} fd  
         */
        constructor(debug: Boolean, fd:FluidDiagrams) {
            this.debug = debug;
            this.fd = fd;
        }

        /**
         * Creates and returnes the visualisation object
         * @memberof FDVisualisationFactory
         * @function getVisualisation
         * @param {string} type 
         */
        public getVisualisation(type): FDVisualisation {
            if (type == "ConeTree") {
                return new ConeTreeVisualisation(this.debug, this.fd);
            } else if (type == "ParallelCoordinates") {
                return new ParallelCoordinatesVisualisation(this.debug, this.fd);
            } else if (type == "LineChart") {
                return new LineChartVisualisation(this.debug, this.fd);
            } else if (type == "BarChart") {
                return new BarChartVisualisation(this.debug, this.fd);
            } else if (type == "ScatterPlot") {
                return new ScatterPlotVisualisation(this.debug, this.fd);
            } else if(type=="HyperBolicBrowser"){
				//comment
                return new HypB(this.debug,this.fd);
            }
        }

    }
}
