/// <reference path="Scatterplot/ScatterPlotVisualisation.ts" />
/// <reference path="BarChart/BarChartVisualisation.ts" />
/// <reference path="FDVisualisation.ts" />
/// <reference path="ConeTree\ConeTreeVisualisation.ts" />
/// <reference path="ParallelCoordinates\ParallelCoordinatesVisualisation.ts" />
/// <reference path="LineChart\LineChartVisualisation.ts" />
/// <reference path="Hyperbolic\HypB.ts" />
var FD;
(function (FD) {
    var FDVisualisationFactory = (function () {
        /**
        * Factory to create predefined visualisations
        * @class FDVisualisationFactory
        * @classdesc Factory to create predefined visualisations
        * @param {bool} debug
        * @param {FluidDiagrams} fd
        */
        function FDVisualisationFactory(debug, fd) {
            this.debug = true;
            this.debug = debug;
            this.fd = fd;
        }
        /**
        * Creates and returnes the visualisation object
        * @memberof FDVisualisationFactory
        * @function getVisualisation
        * @param {string} type
        */
        FDVisualisationFactory.prototype.getVisualisation = function (type) {
            if (type == "ConeTree") {
                return new FD.ConeTreeVisualisation(this.debug, this.fd);
            } else if (type == "ParallelCoordinates") {
                return new FD.ParallelCoordinatesVisualisation(this.debug, this.fd);
            } else if (type == "LineChart") {
                return new FD.LineChartVisualisation(this.debug, this.fd);
            } else if (type == "BarChart") {
                return new FD.BarChartVisualisation(this.debug, this.fd);
            } else if (type == "ScatterPlot") {
                return new FD.ScatterPlotVisualisation(this.debug, this.fd);
            } else if (type == "PolarArea") {
                return new FD.PolarAreaVisualisation(this.debug, this.fd);
            } else if (type == "TreeMap") {
                return new FD.TreeMapVisualisation(this.debug, this.fd);
            } else if (type == "HyperBolicBrowser") {
                //comment
                return new FD.HypB(this.debug, this.fd);
            }
        };
        return FDVisualisationFactory;
    })();
    FD.FDVisualisationFactory = FDVisualisationFactory;
})(FD || (FD = {}));
