/// <reference path="debugPrinter.ts" />
/// <reference path="FDNode.ts" />
/// <reference path="resources/three.d.ts" />


module FD {
    export class FDVisualisation {

        public debug: Boolean = true;
        public nodes: FDNode[];
        public allNodes: FDNode[];
        public width: number;
        public height: number;
        public fluidDiagrams: FluidDiagrams;
        public backgroundColor;

        /**
        * Creates a new instance of FDVisualisation
        * @class FDVisualisation
        * @classdesc Template Class for the visualisation.
        * @param {bool} [debug] 
        * @param {FluidDiagrams} fluidDiagrams Refference to th emain class
        */
        constructor(debug: Boolean, fluidDiagrams: FluidDiagrams) {
            this.debug = debug;
            this.fluidDiagrams = fluidDiagrams;
            this.backgroundColor = 0x000000;
        }

        /**
        * Set the ROOT nodes. For Hierarchies this should be one root node. For tabular data each node should be a root node. This method is called by FluidDiagrams
        * @memberof FDVisualisation
        * @function setNodes
        * @param {FDNode[]} nodes Array of root nodes. 
        */
        public setNodes(nodes: FDNode[]) {
            this.nodes = nodes;
        }

        /**
        * Set all nodes. This should be all the nodes even non Root.
        * @memberof FDVisualisation
        * @function setAllNodes
        * @param {FDNode[]} nodes Array of all nodes. 
        */
        public setAllNodes(nodes: FDNode[]) {
            this.allNodes = nodes;
        }
        /**
        * Sets dimension of the visualisation. This method is called by FluidDiagrams
        * @memberof FDVisualisation
        * @function setDimesions
        * @param {int} width 
        * @param {int} height
        */
        public setDimensions(width: number, height: number) {
            this.width = width;
            this.height = height;
        }


        /**
        * This is called by FluidDiagrams and should contain the logic for creating the visualisation in 2d/3d
        * @memberof FDVisualisation
        * @function visualise
        */
        public visualise() {
            debugPrinter.print("empty visualisation!! Please implement .visualise() method", this.debug);
        }



    }
}
