/// <reference path="FDParser.ts" />
/// <reference path="JSONParser.ts" />
/// <reference path="CSVParser.ts" />s


module FD {
    export class FDParserFactory {

        debug: Boolean = true;


        /**
         * Factory to create predefined parsers or a empty parser which can be modified using prototyping
         * @class FDParserFactory
         * @classdesc Factory to create predefined parsers or a empty parser which can be modified using prototyping
         * @param {bool} debug
         */
        constructor(debug: Boolean) {
            this.debug = debug;
        }
        /**
         * Creates and returns the defined parser
        * @memberof FDParserFactory
         * @function getParser
         * @param {string} type
         */
        public getParser(type: string):FDParser {
            if (type == "JSON") {
                return new JSONParser(this.debug);
            } else if (type == "CSV") {
                return new CSVParser(this.debug);
            }
        }

    }
}