/// <reference path="FDParser.ts" />
/// <reference path="JSONParser.ts" />
/// <reference path="CSVParser.ts" />s
var FD;
(function (FD) {
    var FDParserFactory = (function () {
        /**
        * Factory to create predefined parsers or a empty parser which can be modified using prototyping
        * @class FDParserFactory
        * @classdesc Factory to create predefined parsers or a empty parser which can be modified using prototyping
        * @param {bool} debug
        */
        function FDParserFactory(debug) {
            this.debug = true;
            this.debug = debug;
        }
        /**
        * Creates and returns the defined parser
        * @memberof FDParserFactory
        * @function getParser
        * @param {string} type
        */
        FDParserFactory.prototype.getParser = function (type) {
            if (type == "JSON") {
                return new FD.JSONParser(this.debug);
            } else if (type == "CSV") {
                return new FD.CSVParser(this.debug);
            }
        };
        return FDParserFactory;
    })();
    FD.FDParserFactory = FDParserFactory;
})(FD || (FD = {}));
