/// <reference path="FDNode.ts" />
/// <reference path="debugPrinter.ts" />



module FD {
    export class FDParser {

        public rootNodes: FDNode[];
        public allNodes: FDNode[];
        public debug: Boolean = true;
        public rawData = "";
        public uId: string;
        public childrenId: string;
        public siblingId: string;

        /**
        * Creates a new instance of FDParser
        * @class FDParser
        * @classdesc Template Class for parsers
        * @param {bool} [debug]  
        */
        constructor(debug: Boolean) {
            this.debug = debug;
            this.rootNodes = [];
            this.allNodes = [];
        }

        /**
        * Set the raw data to be parsed
        * @memberof FDParser
        * @function setRawData
        * @param data 
        */
        public setRawData(data) {
            this.rawData = data;
        }
        /**
        * Set the unique identifier to identify each individual Node. 
        * @memberof FDParser
        * @function setUIdentifier
        * @param {string} uid 
        */
        public setUIdentifierFieldName(uid: string) {
            this.uId = uid;
        }

        /**
        * Set the field name in the data identifying children.
        * @memberof FDParser
        * @function setchildIdentifier
        * @param {string} cid 
        */
        public setchildIdentifier(cid: string) {
            this.childrenId = cid;
        }

        /**
        * Set the field name in the data identifying sibling.
        * @memberof FDParser
        * @function setSiblingIdentifier
        * @param {string} sid 
        */
        public setSiblingIdentifier(sid: string) {
            this.siblingId = sid;
        }

        /**
        * Add a root node
        * @memberof FDParser
        * @function addRootNode
        * @param {FDNode} n 
        */
        public addRootNode(n: FDNode) {
            this.rootNodes.push(n);
        }

        /**
        * Return all root nodes.
        * @memberof FDParser
        * @function getRootNodes
        * @returns {FDNode[]} root nodes
        */
        public getRootNodes(): FDNode[] {
            return this.rootNodes;
        }

        /**
        * Return all nodes.
        * @memberof FDParser
        * @function getAllNodes
        * @returns {FDNode[]} all nodes
        */
        public getAllNodes() {
            return this.allNodes;
        }

        /**
        * add a  non root node
        * @memberof FDParser
        * @function addNode
        * @param {FDNode} n
        */
        public addNode(n: FDNode) {
            this.allNodes.push(n);
        }



        /**
        * parse the data and create the node hierarchy(or root nodes only depending on the data).
        * @memberof FDParser
        * @function parse
        */
        public parse() {
            debugPrinter.print("empty parser!! Please implement .parse() method", this.debug);
        }

    }
}