/// <reference path="FDNode.ts" />
/// <reference path="debugPrinter.ts" />
var FD;
(function (FD) {
    var FDParser = (function () {
        /**
        * Creates a new instance of FDParser
        * @class FDParser
        * @classdesc Template Class for parsers
        * @param {bool} [debug]
        */
        function FDParser(debug) {
            this.debug = true;
            this.rawData = "";
            this.debug = debug;
            this.rootNodes = [];
            this.allNodes = [];
        }
        /**
        * Set the raw data to be parsed
        * @memberof FDParser
        * @function setRawData
        * @param data
        */
        FDParser.prototype.setRawData = function (data) {
            this.rawData = data;
        };

        /**
        * Set the unique identifier to identify each individual Node.
        * @memberof FDParser
        * @function setUIdentifier
        * @param {string} uid
        */
        FDParser.prototype.setUIdentifierFieldName = function (uid) {
            this.uId = uid;
        };

        /**
        * Set the field name in the data identifying children.
        * @memberof FDParser
        * @function setchildIdentifier
        * @param {string} cid
        */
        FDParser.prototype.setchildIdentifier = function (cid) {
            this.childrenId = cid;
        };

        /**
        * Set the field name in the data identifying sibling.
        * @memberof FDParser
        * @function setSiblingIdentifier
        * @param {string} sid
        */
        FDParser.prototype.setSiblingIdentifier = function (sid) {
            this.siblingId = sid;
        };

        /**
        * Add a root node
        * @memberof FDParser
        * @function addRootNode
        * @param {FDNode} n
        */
        FDParser.prototype.addRootNode = function (n) {
            this.rootNodes.push(n);
        };

        /**
        * Return all root nodes.
        * @memberof FDParser
        * @function getRootNodes
        * @returns {FDNode[]} root nodes
        */
        FDParser.prototype.getRootNodes = function () {
            return this.rootNodes;
        };

        /**
        * Return all nodes.
        * @memberof FDParser
        * @function getAllNodes
        * @returns {FDNode[]} all nodes
        */
        FDParser.prototype.getAllNodes = function () {
            return this.allNodes;
        };

        /**
        * add a  non root node
        * @memberof FDParser
        * @function addNode
        * @param {FDNode} n
        */
        FDParser.prototype.addNode = function (n) {
            this.allNodes.push(n);
        };

        /**
        * parse the data and create the node hierarchy(or root nodes only depending on the data).
        * @memberof FDParser
        * @function parse
        */
        FDParser.prototype.parse = function () {
            FD.debugPrinter.print("empty parser!! Please implement .parse() method", this.debug);
        };
        return FDParser;
    })();
    FD.FDParser = FDParser;
})(FD || (FD = {}));
