
/*
Created by Benedict Wright
*/

/// <reference path="resources/three.d.ts" />

module FD {
    export class FDGeomObject {
        private geometry: THREE.Geometry;
        private material: THREE.Material;
        private interactive: boolean;
        private materialIndex: number;


        constructor(interactive: boolean) {

            this.interactive = interactive;

        }

        public setGeometry(geometry: THREE.Geometry) {
            this.geometry = geometry;
        }

        public getGeometry(): THREE.Geometry {
            return this.geometry;
        }

        public setMaterial(material: THREE.Material) {
            this.material = material;
        }

        public getMaterial(): THREE.Material {
            return this.material;
        }

        public transform(matrix: THREE.Matrix4) {
            this.geometry.applyMatrix(matrix);
        }

        public isInteractive(): boolean {
            return this.interactive;
        }

        public setMaterialIndex(index: number) {
            this.materialIndex = index;
        }

        public getMesh(): THREE.Mesh {
            var m = new THREE.Mesh(this.geometry, <any>this.material);
            THREE.GeometryUtils.setMaterialIndex(m.geometry, this.materialIndex);
            return m;
        }

    }
}