/*
Created by Benedict Wright
*/
/// <reference path="resources/three.d.ts" />
var FD;
(function (FD) {
    var FDGeomObject = (function () {
        function FDGeomObject(interactive) {
            this.interactive = interactive;
        }
        FDGeomObject.prototype.setGeometry = function (geometry) {
            this.geometry = geometry;
        };

        FDGeomObject.prototype.getGeometry = function () {
            return this.geometry;
        };

        FDGeomObject.prototype.setMaterial = function (material) {
            this.material = material;
        };

        FDGeomObject.prototype.getMaterial = function () {
            return this.material;
        };

        FDGeomObject.prototype.transform = function (matrix) {
            this.geometry.applyMatrix(matrix);
        };

        FDGeomObject.prototype.isInteractive = function () {
            return this.interactive;
        };

        FDGeomObject.prototype.setMaterialIndex = function (index) {
            this.materialIndex = index;
        };

        FDGeomObject.prototype.getMesh = function () {
            var m = new THREE.Mesh(this.geometry, this.material);
            THREE.GeometryUtils.setMaterialIndex(m.geometry, this.materialIndex);
            return m;
        };
        return FDGeomObject;
    })();
    FD.FDGeomObject = FDGeomObject;
})(FD || (FD = {}));
