/// <reference path="resources/three.d.ts" />
/// <reference path="debugPrinter.ts" />
/// <reference path="FDNode.ts" />
/// <reference path="FluidDiagrams.ts" />


module FD {
    export class FDEventHandler {
        public debug: Boolean;
        public mouseDown: boolean;
        public fluidDiagrams: FluidDiagrams;

        /**
        * Creates a new instance of FDEventHandler
        * @class FDEventHandler
        * @classdesc Template Class for the eventhandlers.
        * @param {bool} [debug] 
        * @param {FluidDiagrams} fluidDiagram Refference to the main class
        */
        constructor(debug: Boolean, fluidDiagram: FluidDiagrams) {
            this.debug = debug;
            this.mouseDown = false;
            this.fluidDiagrams = fluidDiagram;
        }

        /**
        * Invoked on mouse down
        * @memberof FDEventHandler
        * @function onMouseDown
        * @param {Event} e DOM Event
        */
        public onMouseDown(e: Event) {

            debugPrinter.print("MouseDown not implemented", this.debug);

        }

        /**
        * Invoked on mouse up
        * @memberof FDEventHandler
        * @function onMouseUp
        * @param {Event} e DOM Event
        */
        public onMouseUp(e: Event) {
            debugPrinter.print("MouseUp not implemented", this.debug);
        }

        /**
        * Invoked on mouse move
        * @memberof FDEventHandler
        * @function onMouseMove
        * @param {Event} e DOM Event
        */
        public onMouseMove(e: Event) {
            debugPrinter.print("MouseMove not implemented", this.debug);
        }

        /**
        * Invoked on mouse wheel
        * @memberof FDEventHandler
        * @function mouseWheel
        * @param {Event} e DOM Event
        */
        public mouseWheel(e: Event) {
            debugPrinter.print("MouseWheel not implemented", this.debug);
        }

        /**
        * Invoked on mouse click
        * @memberof FDEventHandler
        * @function onMouseClick
        * @param {Event} e DOM Event
        * @param {element} element is a FDNode if a node was clicked, THREE.Mesh when a Mesh not within a Node ways clicked or null otherwhise
        */
        public onMouseClick(e: Event, element) {
            //IF a node wa clicked element is a FDNode
            //Else it is the clicked Mesh
            debugPrinter.print("MouseClick not implemented", this.debug);
        }


        /**
        * Invoked before each frame. Can be used for Animations or other actions needed to be repeated in every loop
        * @memberof FDEventHandler
        * @function update
        * 
        */
        public update() {
            //animation update here
        }
    }
}
