/// <reference path="resources/three.d.ts" />
/// <reference path="debugPrinter.ts" />
/// <reference path="FDNode.ts" />
/// <reference path="FluidDiagrams.ts" />
var FD;
(function (FD) {
    var FDEventHandler = (function () {
        /**
        * Creates a new instance of FDEventHandler
        * @class FDEventHandler
        * @classdesc Template Class for the eventhandlers.
        * @param {bool} [debug]
        * @param {FluidDiagrams} fluidDiagram Refference to the main class
        */
        function FDEventHandler(debug, fluidDiagram) {
            this.debug = debug;
            this.mouseDown = false;
            this.fluidDiagrams = fluidDiagram;
        }
        /**
        * Invoked on mouse down
        * @memberof FDEventHandler
        * @function onMouseDown
        * @param {Event} e DOM Event
        */
        FDEventHandler.prototype.onMouseDown = function (e) {
            FD.debugPrinter.print("MouseDown not implemented", this.debug);
        };

        /**
        * Invoked on mouse up
        * @memberof FDEventHandler
        * @function onMouseUp
        * @param {Event} e DOM Event
        */
        FDEventHandler.prototype.onMouseUp = function (e) {
            FD.debugPrinter.print("MouseUp not implemented", this.debug);
        };

        /**
        * Invoked on mouse move
        * @memberof FDEventHandler
        * @function onMouseMove
        * @param {Event} e DOM Event
        */
        FDEventHandler.prototype.onMouseMove = function (e) {
            FD.debugPrinter.print("MouseMove not implemented", this.debug);
        };

        /**
        * Invoked on mouse wheel
        * @memberof FDEventHandler
        * @function mouseWheel
        * @param {Event} e DOM Event
        */
        FDEventHandler.prototype.mouseWheel = function (e) {
            FD.debugPrinter.print("MouseWheel not implemented", this.debug);
        };

        /**
        * Invoked on mouse click
        * @memberof FDEventHandler
        * @function onMouseClick
        * @param {Event} e DOM Event
        * @param {element} element is a FDNode if a node was clicked, THREE.Mesh when a Mesh not within a Node ways clicked or null otherwhise
        */
        FDEventHandler.prototype.onMouseClick = function (e, element) {
            //IF a node wa clicked element is a FDNode
            //Else it is the clicked Mesh
            FD.debugPrinter.print("MouseClick not implemented", this.debug);
        };

        /**
        * Invoked before each frame. Can be used for Animations or other actions needed to be repeated in every loop
        * @memberof FDEventHandler
        * @function update
        *
        */
        FDEventHandler.prototype.update = function () {
            //animation update here
        };
        return FDEventHandler;
    })();
    FD.FDEventHandler = FDEventHandler;
})(FD || (FD = {}));
