var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
/// <reference path="ConeTreeVisualisation.ts" />
/// <reference path="ConeTreeNode.ts" />
/// <reference path="../resources/three.d.ts" />
/// <reference path="../debugPrinter.ts" />
/// <reference path="../FDEventHandler.ts" />
/// <reference path="../FDHelpers.ts" />
var FD;
(function (FD) {
    var ConeTreeEventHandler = (function (_super) {
        __extends(ConeTreeEventHandler, _super);
        function ConeTreeEventHandler(debug, fluidDiagrams) {
            _super.call(this, debug, fluidDiagrams);
            this.mouseDown = false;
            this.mouseDownPosition = new THREE.Vector2();
            this.selected = null;
            this.animate = true;
        }
        ConeTreeEventHandler.prototype.onMouseDown = function (e) {
            //debugPrinter.print("ConeTree MouseDown", this.debug);
            this.mouseDownPosition.x = (e).clientX;
            this.mouseDownPosition.y = (e).clientY;
            this.mouseDown = true;
        };

        ConeTreeEventHandler.prototype.onMouseUp = function (e) {
            // debugPrinter.print("ConeTree MouseUp", this.debug);
            this.mouseDown = false;
        };

        ConeTreeEventHandler.prototype.onMouseClick = function (e, element) {
            if (element != null && element instanceof FD.FDNode) {
                if (this.selected != null) {
                    this.selected.getAllGeometry()[0].material = this.selectedMat;
                }
                this.selected = element;
                this.selectedMat = element.getAllGeometry()[0].material;
                element.getAllGeometry()[0].material = new THREE.MeshBasicMaterial({ color: 0xffffff });
                this.rotateRecursive(element);
                //recursive up
            }
        };

        ConeTreeEventHandler.prototype.onMouseMove = function (e) {
            if (this.mouseDown === true) {
                var x = (e).clientX - this.mouseDownPosition.x;
                var y = (e).clientY - this.mouseDownPosition.y;

                this.fluidDiagrams.camera.translateX(-x / 2);
                this.fluidDiagrams.camera.translateY(y / 2);
                this.mouseDownPosition.x = (e).clientX;
                this.mouseDownPosition.y = (e).clientY;
            }
        };

        ConeTreeEventHandler.prototype.mouseWheel = function (e) {
            var ev = window.event || e;
            var delta = Math.max(-1, Math.min(1, (ev).wheelDelta || -(e).detail));

            //camera looks at -z in camera space (we can use this to move forward and backward)
            var zoom = (this.fluidDiagrams.camera).zoom;
            if (zoom >= 0.2) {
                var newZoom = zoom + delta / 10;
                newZoom <= 0.2 ? 0.2 : newZoom;
                (this.fluidDiagrams.camera).setZoom(newZoom);
            } else {
                (this.fluidDiagrams.camera).setZoom(0.2);
            }
        };

        ConeTreeEventHandler.prototype.update = function () {
        };

        ConeTreeEventHandler.prototype.rotateRecursive = function (node) {
            if (node.getParent() != null) {
                var currentPossition = node.getWorldCoordinates();
                var parentPossition = node.getParent().getWorldCoordinates();

                //calculate angel between old and new possition on x/z plane
                //debugPrinter.print("node current pos " + currentPossition.x + "/" + currentPossition.z, this.debug);
                var tarz = parentPossition.z + (node.getParent()).radius;
                var tarx = parentPossition.x;

                //debugPrinter.print("target of rotation: " + tarx + "/" + tarz, this.debug);
                var phi = FD.threePointAngle(new THREE.Vector2(currentPossition.x, currentPossition.z), new THREE.Vector2(parentPossition.x, parentPossition.z), new THREE.Vector2(tarx, tarz));

                var correction = this.rotateRecursive(node.getParent());

                if (correction >= 0 && currentPossition.x < parentPossition.x) {
                    phi = phi - correction;
                } else if (correction >= 0 && currentPossition.x > parentPossition.x) {
                    phi = -phi - correction;
                } else if (correction < 0 && currentPossition.x < parentPossition.x) {
                    phi = phi + (correction * -1);
                } else if (correction < 0 && currentPossition.x > parentPossition.x) {
                    phi = -phi - correction;
                }
                var cor = phi + correction;

                if (!isNaN(phi)) {
                    var phi_ = node.getParent().getNodeSceneGraph().rotation.y + phi;

                    if (this.animate === true) {
                        var parenttween = new TWEEN.Tween(node.getParent().getNodeSceneGraph().rotation).to({ y: phi_ }, 2000).start();
                    } else {
                        node.getParent().getNodeSceneGraph().rotation.y = phi_;
                    }

                    return cor;
                } else {
                    return 0;
                }
            } else {
                return 0;
            }
        };

        ConeTreeEventHandler.prototype.toggleShadows = function (active) {
            if (active == false) {
                for (var len = 0; len < (this.fluidDiagrams.getVisualisation()).shadows.length; len++) {
                    (this.fluidDiagrams.getVisualisation()).shadows[len].visible = false;
                }
            } else {
                for (var len = 0; len < (this.fluidDiagrams.getVisualisation()).shadows.length; len++) {
                    (this.fluidDiagrams.getVisualisation()).shadows[len].visible = true;
                }
            }
        };

        ConeTreeEventHandler.prototype.toggleLabels = function (active) {
            if (active == false) {
                for (var len = 0; len < (this.fluidDiagrams.getVisualisation()).labels.length; len++) {
                    (this.fluidDiagrams.getVisualisation()).labels[len].visible = false;
                }
            } else {
                for (var len = 0; len < (this.fluidDiagrams.getVisualisation()).labels.length; len++) {
                    (this.fluidDiagrams.getVisualisation()).labels[len].visible = true;
                }
            }
        };

        ConeTreeEventHandler.prototype.toggleAnimation = function (active) {
            this.animate = active;
        };
        return ConeTreeEventHandler;
    })(FD.FDEventHandler);
    FD.ConeTreeEventHandler = ConeTreeEventHandler;
})(FD || (FD = {}));
