/*
Created by Benedict Wright
Parser for CSV files for tabular data
*/


/// <reference path="FDParser.ts" />
/// <reference path="resources/jquery.d.ts" />
module FD {
    export class CSVParser extends FDParser {

        private seperator = ',';
        private header: string[];

        constructor(debug: Boolean) {
            super(debug);
            this.header = [];
        }


        public setSeperator(sep: string) {
            this.seperator = sep;
        }

        public parse() {
            var lines = this.rawData.split('\n');
            //firstline is header
            var h = lines[0].split(this.seperator);
            for (var i = 0; i < h.length; i++) {
                this.header[i] = h[i].toString().replace(/"/g, '').trim();
            }

            //get index of uniqueId
            var uidI = this.header.indexOf(this.uId);

            for (var i = 1; i < lines.length; i++) {
                var ele = lines[i].split(this.seperator);
                //debugPrinter.print(ele[0],this.debug);
                var node = new FDNode();
                node.setUniqueId(ele[uidI]);
                var data = new Object;
                for (var x = 0; x < ele.length; x++) {
                    if (this.header[x] != this.uId)
                        data[this.header[x]] = ele[x].toString().trim();
                }
                node.setData(data);
                this.addRootNode(node);
            }
        }

    }
}