/*
Created by Benedict Wright
Parser for CSV files for tabular data
*/
var __extends = this.__extends || function (d, b) {
    for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p];
    function __() { this.constructor = d; }
    __.prototype = b.prototype;
    d.prototype = new __();
};
/// <reference path="FDParser.ts" />
/// <reference path="resources/jquery.d.ts" />
var FD;
(function (FD) {
    var CSVParser = (function (_super) {
        __extends(CSVParser, _super);
        function CSVParser(debug) {
            _super.call(this, debug);
            this.seperator = ',';
            this.header = [];
        }
        CSVParser.prototype.setSeperator = function (sep) {
            this.seperator = sep;
        };

        CSVParser.prototype.parse = function () {
            var lines = this.rawData.split('\n');

            //firstline is header
            var h = lines[0].split(this.seperator);
            for (var i = 0; i < h.length; i++) {
                this.header[i] = h[i].toString().replace(/"/g, '').trim();
            }

            //get index of uniqueId
            var uidI = this.header.indexOf(this.uId);

            for (var i = 1; i < lines.length; i++) {
                var ele = lines[i].split(this.seperator);

                //debugPrinter.print(ele[0],this.debug);
                var node = new FD.FDNode();
                node.setUniqueId(ele[uidI]);
                var data = new Object;
                for (var x = 0; x < ele.length; x++) {
                    if (this.header[x] != this.uId)
                        data[this.header[x]] = ele[x].toString().trim();
                }
                node.setData(data);
                this.addRootNode(node);
            }
        };
        return CSVParser;
    })(FD.FDParser);
    FD.CSVParser = CSVParser;
})(FD || (FD = {}));
