/// <reference path="../FDNode.ts" />



module FD {
  
    export interface Bar {
        id?: number;
        height: number;
        color: number;
        hooverText: string;
        name: string;
    }

    export class BarChartBlock {

        some: string;
        public cName: string;
        public entries: Bar[];
        public shadowEntries: Bar[];
        public overShadowEntries: Bar[];

        constructor(name: string) {
            this.some = "asdasd";
            this.cName = name;
            this.entries = [];
            this.shadowEntries = [];
            this.overShadowEntries = [];
        }

        public addEntry(newHeight: number, newColour: number, newHooverText: string, newName: string) {
            this.entries[this.entries.length] = { height: newHeight, color: newColour, hooverText: newHooverText, name: newName };
        }

        public addShadowEntry(newHeight: number, newColour: number, newHooverText: string, newName: string) {
            this.shadowEntries[this.shadowEntries.length] = { height: newHeight, color: newColour, hooverText: newHooverText, name: newName };
        }

        public addOverShadowEntry(newHeight: number, newColour: number, newHooverText: string, newName: string) {
            this.overShadowEntries[this.overShadowEntries.length] = { height: newHeight, color: newColour, hooverText: newHooverText, name: newName };
        }


        public addID(entrie: number, newID: number) {
            this.entries[entrie].id = newID
    }

        public addShadowID(entry: number, newID: number) {
            this.shadowEntries[entry].id = newID
    }

        public addOverShadowID(entry: number, newID: number) {
            this.overShadowEntries[entry].id = newID
    }


        public printEntries() {
            for (var i = 0; i < this.entries.length; i++) {
                alert(this.entries[i].color + " ");
            }
        }

    }
}




